/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.util;

import DE.siemens.ad.logo.model.BlockVMMappingInfo;
import DE.siemens.ad.logo.model.EthernetConnection;
import DE.siemens.ad.logo.model.NetworkConfiguration;
import DE.siemens.ad.logo.model.ParameterItem;
import DE.siemens.ad.logo.model.WiringDiagram;
import DE.siemens.ad.logo.util.IPV4Utils;
import DE.siemens.ad.logo.util.Memory16;
import DE.siemens.ad.logo.util.Memory8;
import DE.siemens.ad.udf.UDFParameterItem;
import java.util.Vector;

public class NetworkMemoryV7
extends Memory8 {
    private static final int CONNECTION_SIZE = 12;
    private static final int TRANSFER_SIZE = 12;
    public static final int N_COUNT = 64;
    public static final int AN_COUNT = 32;
    private static final int N_TOTAL_COUNT = 96;
    public static final int N_MEMORY_SIZE = 6;
    public static final int SQ_COUNT = 64;
    public static final int SAQ_COUNT = 16;
    public static final int SQ_TOTAL_COUNT = 80;
    public static final int SQ_MEMORY_SIZE = 5;
    public static final int PARAM_COUNT = 64;
    public static final int PARAM_MEMORY_SIZE = 5;
    private static final int CONNECTION_COUNT_OFFSET = 2;
    private static final int TRANSFER_COUNT_OFFSET = 4;
    private static final int CONNECTION_OFFSET = 6;

    public NetworkMemoryV7(int startAddress, int connectionCount, int transferCount) {
        super("Network Memory", startAddress, 1, 6 + connectionCount * 12 + transferCount * 12 + 576 + 400 + 320);
        this.setConnectionCount(connectionCount);
        this.setTransferCount(transferCount);
    }

    public void init(int initByte) {
        int blockSize = this.fMemory[0].length;
        for (int byteIdx = 6; byteIdx < blockSize; ++byteIdx) {
            this.fMemory[0][byteIdx] = initByte;
        }
    }

    public NetworkMemoryV7(String name, int startAdresse, int memorySize, int blockSize) {
        super(name, startAdresse, memorySize, blockSize);
    }

    public void writeConnections(NetworkConfiguration config) {
        int transferIndex = 0;
        int connIndex = 0;
        for (EthernetConnection connection : config.getEthernetConnections()) {
            if (connection == null) continue;
            transferIndex = this.setConnection(connection, connIndex, transferIndex);
            ++connIndex;
        }
    }

    public void readNetworkConfiguration(NetworkConfiguration config) {
        for (int i = 0; i < this.getConnectionCount(); ++i) {
            EthernetConnection connection = this.getConnection(i);
            config.getEthernetConnections().add(connection);
        }
    }

    public void writeBlockVMMappingInfo(BlockVMMappingInfo mappingInfo, Memory16 programOffsetTable) {
        this.setPosition(6 + this.getConnectionCount() * 12 + this.getTransferCount() * 12);
        Vector<BlockVMMappingInfo.Param2VMInfo> list = mappingInfo.getMappingInfo();
        for (BlockVMMappingInfo.Param2VMInfo item : list) {
            this.setParam2VM(item, programOffsetTable);
        }
    }

    private void setParam2VM(BlockVMMappingInfo.Param2VMInfo item, Memory16 programOffsetTable) {
        this.putWord(item.length << 13 | item.address);
        if (item.paramItem instanceof UDFParameterItem) {
            ParameterItem rootItem = ((UDFParameterItem)item.paramItem).getRootSourceParameterItem();
            this.putWord(rootItem.getParameter().getBlock().getNumber());
            this.put(rootItem.getParameterNumber());
        } else {
            this.putWord(item.paramItem.getParameter().getBlock().getNumber());
            this.put(item.paramItem.getParameterNumber());
        }
    }

    public BlockVMMappingInfo readBlockVMMappingInfo(WiringDiagram wd, Memory16 programOffsetTable) {
        this.setPosition(6 + this.getConnectionCount() * 12 + this.getTransferCount() * 12);
        BlockVMMappingInfo blockVMMappingInfo = new BlockVMMappingInfo();
        for (int i = 0; i < 64; ++i) {
            BlockVMMappingInfo.Param2VMInfo info = this.getParam2VM(wd, programOffsetTable);
            if (info == null) continue;
            blockVMMappingInfo.getMappingInfo().add(info);
        }
        return blockVMMappingInfo;
    }

    private BlockVMMappingInfo.Param2VMInfo getParam2VM(WiringDiagram wd, Memory16 programOffsetTable) {
        int firstWord = this.nextWord();
        int address = firstWord & 0x1FFF;
        int blockNr = this.nextWord();
        int paramNr = this.nextByte();
        if (blockNr == 65535) {
            return null;
        }
        BlockVMMappingInfo.Param2VMInfo info = new BlockVMMappingInfo.Param2VMInfo();
        info.address = address;
        info.paramItem = wd.getParameterItem(blockNr, paramNr);
        info.length = firstWord >> 13;
        return info;
    }

    private void setConnectionCount(int count) {
        this.setPosition(2);
        this.put(count & 0xFF);
    }

    private int getConnectionCount() {
        int connCount = this.getWord(2) & 0xFF;
        if (connCount == 255) {
            connCount = 0;
        }
        return connCount;
    }

    private void setTransferCount(int count) {
        this.setPosition(4);
        this.putWord(count);
    }

    private int getTransferCount() {
        int transferCount = this.getWord(4);
        if (transferCount == 65535) {
            transferCount = 0;
        }
        return transferCount;
    }

    private int setConnection(EthernetConnection connection, int connIndex, int transferIndex) {
        this.setPosition(6 + connIndex * 12);
        int property = 0;
        if (connection.isClient()) {
            if (connection.isNotCreateByUser()) {
                property |= 4;
            }
        } else {
            property |= 1;
        }
        if (connection.getAliveInterval() != 0) {
            property |= 2;
        }
        this.put(property);
        if (connection.isClient()) {
            this.putDoubleWord(IPV4Utils.getInstance().formatToInt(connection.getRemoteIP()));
        } else if (connection.getAcceptedIP() != null && connection.getAcceptedIP().length() != 0) {
            this.putDoubleWord(IPV4Utils.getInstance().formatToInt(connection.getAcceptedIP()));
        } else {
            this.putDoubleWord(0);
        }
        this.putWord(NetworkMemoryV7.getTSAPIntValue(connection.getLocalTsap(), 2));
        this.putWord(NetworkMemoryV7.getTSAPIntValue(connection.getRemoteTsap(), 2));
        this.putWord(transferIndex);
        int transferCount = connection.isClient() ? connection.getVMReadTransactions().size() + connection.getVMWriteTransactions().size() : 0;
        this.put(transferCount);
        if (transferCount > 0) {
            int i;
            this.setPosition(6 + this.getConnectionCount() * 12 + transferIndex * 12);
            for (i = 0; i < connection.getVMReadTransactions().size(); ++i) {
                this.setTransfer(connection.getVMReadTransactions().get(i));
            }
            for (i = 0; i < connection.getVMWriteTransactions().size(); ++i) {
                this.setTransfer(connection.getVMWriteTransactions().get(i));
            }
        }
        return transferIndex + transferCount;
    }

    private EthernetConnection getConnection(int index) {
        EthernetConnection connection = new EthernetConnection(index + 1);
        this.setPosition(6 + index * 12);
        int property = this.nextByte();
        connection.setClient((property & 1) == 0);
        connection.setAliveInterval((property & 2) == 0 ? 0 : 5);
        if (connection.isClient()) {
            connection.setRemoteIP(IPV4Utils.getInstance().formatToString(this.nextDoubleWord()));
        } else {
            int acceptedIP = this.nextDoubleWord();
            if (acceptedIP != 0) {
                connection.setAcceptedIP(IPV4Utils.getInstance().formatToString(acceptedIP));
            }
        }
        connection.setLocalTsap(NetworkMemoryV7.getTSAPStringValue(this.nextWord(), 2));
        connection.setRemoteTsap(NetworkMemoryV7.getTSAPStringValue(this.nextWord(), 2));
        int transferIndex = this.nextWord();
        int transferCount = this.nextByte();
        this.setPosition(6 + this.getConnectionCount() * 12 + transferIndex * 12);
        for (int i = 0; i < transferCount; ++i) {
            connection.addVMTransaction(this.getTransfer());
        }
        return connection;
    }

    private void setTransfer(EthernetConnection.Transfer transfer) {
        this.put(transfer.fOperateCode);
        this.put(transfer.fDataUnit);
        this.putWord(transfer.fLocalAddress);
        this.put(transfer.fLocalDataBlockType & 0xF | (transfer.fRemoteDataBlockType & 0xF) << 4);
        if (transfer.fRemoteDataBlockType == 1) {
            this.putWord(transfer.fBlockAddress);
            this.put(transfer.fBlockByteAddress >> 16);
            this.putWord(transfer.fBlockByteAddress & 0xFFFF);
        } else {
            this.putWord(1);
            this.put(0);
            this.putWord(transfer.fRemoteAddress);
        }
        this.putWord(transfer.fLength);
    }

    private EthernetConnection.Transfer getTransfer() {
        EthernetConnection.Transfer ret = new EthernetConnection.Transfer();
        int property = this.nextByte();
        ret.fOperateCode = property & 1;
        ret.fDataUnit = this.nextByte();
        ret.fLocalAddress = this.nextWord();
        int dataType = this.nextByte();
        ret.fLocalDataBlockType = dataType & 0xF;
        ret.fRemoteDataBlockType = (dataType & 0xF0) >> 4;
        if (ret.fRemoteDataBlockType == 1) {
            ret.fBlockAddress = this.nextWord();
            ret.fBlockByteAddress = this.nextByte() << 16 | this.nextWord();
        } else {
            this.nextWord();
            this.nextByte();
            ret.fRemoteAddress = this.nextWord();
        }
        ret.fLength = this.nextWord();
        return ret;
    }

    public int getOffsetForNetworkBlockInfo(int type) {
        int start = 6 + this.getConnectionCount() * 12 + this.getTransferCount() * 12 + 320;
        if (type == 22) {
            return start;
        }
        if (type == 23) {
            return start + 384;
        }
        if (type == 27) {
            return start + 576;
        }
        if (type == 28) {
            return start + 576 + 320;
        }
        throw new IllegalArgumentException();
    }

    private static int getTSAPIntValue(String address, int size) {
        int pointIndex = address.indexOf(46);
        return Integer.parseInt(NetworkMemoryV7.getValidTSAPString(address.substring(0, pointIndex)) + NetworkMemoryV7.getValidTSAPString(address.substring(pointIndex + 1)), 16);
    }

    private static String getTSAPStringValue(int address, int size) {
        return NetworkMemoryV7.getValidTSAPPart(address >> 8) + "." + NetworkMemoryV7.getValidTSAPPart(address & 0xFF);
    }

    private static String getValidTSAPPart(int address) {
        String str = Integer.toString(address, 16);
        return NetworkMemoryV7.getValidTSAPString(str).toUpperCase();
    }

    private static String getValidTSAPString(String str) {
        if (str.length() > 2) {
            return str.substring(0, 2);
        }
        if (str.length() == 2) {
            return str;
        }
        return "00".substring(0, 2 - str.length()) + str;
    }

    protected String toString(int startLine) {
        int j;
        int i;
        StringBuffer buffer = new StringBuffer();
        buffer.append("\nConnection count:").append(this.getConnectionCount());
        buffer.append("\nTransfer count:").append(this.getTransferCount());
        buffer.append("\nConnection details:");
        int index = 6;
        for (i = 0; i < this.getConnectionCount(); ++i) {
            buffer.append("\n").append(i).append(":\t");
            for (j = 0; j < 12; ++j) {
                buffer.append(Integer.toHexString(this.get(index) & 0xFF));
                if (j < 11) {
                    buffer.append(", ");
                }
                ++index;
            }
        }
        buffer.append("\nTransfer details:");
        for (i = 0; i < this.getTransferCount(); ++i) {
            buffer.append("\n").append(i).append(":\t");
            for (j = 0; j < 12; ++j) {
                buffer.append(Integer.toHexString(this.get(index) & 0xFF));
                if (j < 11) {
                    buffer.append(", ");
                }
                ++index;
            }
        }
        buffer.append("\nParam to VM:");
        for (i = 0; i < 64; ++i) {
            buffer.append("\n").append(i).append(":\t");
            for (j = 0; j < 5; ++j) {
                buffer.append(Integer.toHexString(this.get(index) & 0xFF));
                if (j < 4) {
                    buffer.append(", ");
                }
                ++index;
            }
        }
        index = this.writeNetworkNode(buffer, index, 64, "N");
        index = this.writeNetworkNode(buffer, index, 32, "AN");
        index = this.writeSlaveOutput(buffer, index, 64, "SQ");
        index = this.writeSlaveOutput(buffer, index, 16, "SAQ");
        return buffer.toString();
    }

    private int writeNetworkNode(StringBuffer buffer, int index, int count, String name) {
        buffer.append("\n").append(name).append(" Info:");
        for (int i = 0; i < count; ++i) {
            buffer.append("\n").append(i).append(":\t");
            for (int j = 0; j < 6; ++j) {
                buffer.append(Integer.toHexString(this.get(index) & 0xFF));
                if (j == 0) {
                    buffer.append(", ");
                }
                ++index;
            }
        }
        return index;
    }

    private int writeSlaveOutput(StringBuffer buffer, int index, int count, String name) {
        buffer.append("\n").append(name).append(" details:");
        for (int i = 0; i < count; ++i) {
            buffer.append("\n").append(i).append(":\t");
            for (int j = 0; j < 5; ++j) {
                buffer.append(Integer.toHexString(this.get(index) & 0xFF));
                if (j < 2) {
                    buffer.append(", ");
                }
                ++index;
            }
        }
        return index;
    }

    public int getChecksum() {
        short checksum = 0;
        int start = 0;
        int length = 6 + this.getConnectionCount() * 12 + this.getTransferCount() * 12;
        if (this.getConnectionCount() != 0 || this.getTransferCount() != 0) {
            checksum = (short)(checksum + this.getAreaChecksum(start, length));
        }
        start += length;
        length = 320;
        checksum = (short)(checksum + this.getAreaChecksum(start, length));
        length = 384;
        checksum = (short)(checksum + this.getAreaChecksum(start += 320, length));
        length = 192;
        checksum = (short)(checksum + this.getAreaChecksum(start += 384, length));
        length = 320;
        checksum = (short)(checksum + this.getAreaChecksum(start += 192, length));
        length = 80;
        checksum = (short)(checksum + this.getAreaChecksum(start += 320, length));
        return checksum;
    }

    private short getAreaChecksum(int start, int length) {
        short checksum = 0;
        for (int i = 0; i < length; ++i) {
            checksum = (short)(checksum + this.get(start + i));
        }
        return checksum;
    }
}

